unit ucOrders;

interface

uses
  SysUtils, System.Data, System.Drawing, System.Web, System.Web.UI, System.Text,
  System.Collections, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  Borland.Data.Provider, Borland.Data.Common, SmartDataGrid;
     
type
    /// <summary>
    /// Summary description for WebUserControl1.
    /// </summary>
  TucOrders = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure dgOrders_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    dgOrders: SmartDataGrid.TSmartDataGrid;
    dlSubMenu: System.Web.UI.WebControls.DataList;
    ErrorMessage: System.Web.UI.WebControls.Label;
    lblCustomerID: System.Web.UI.WebControls.Label;
    lblCustomerName: System.Web.UI.WebControls.Label;
    lblCustomerEmail: System.Web.UI.WebControls.Label;
    procedure OnInit(e: System.EventArgs); override;
  private
    procedure GetCustomer(const cid :  string);
    procedure BindSubMenu;
  public
    { Public Declarations }
  end;

implementation

uses Helper, HelperDB;
 
procedure TucOrders.Page_Load(sender: System.Object; e: System.EventArgs);
var
  selSQL : StringBuilder;
begin



  if (Assigned(Request.Params['custid'])) AND (Request.Params['custid'] <> EmptyStr) then
  begin
    ViewState['CustomerID'] := Request.Params['custid'];
    
    GetCustomer(ViewState['CustomerID'].ToString);

    selSQL := StringBuilder.Create;
    selSQL.Append('SELECT Orders.OrderID, ');
    selSQL.Append('SUM(OrderDetails.Quantity * OrderDetails.UnitCost) AS OrderTotal, ');
    selSQL.Append('Orders.OrderDate, Orders.ShipDate ');
    selSQL.Append('FROM Orders INNER JOIN OrderDetails ');
    selSQL.Append('ON Orders.OrderID = OrderDetails.OrderID ');
    selSQL.Append('GROUP BY Orders.CustomerID, Orders.OrderID, ');
    selSQL.Append('Orders.OrderDate, Orders.ShipDate ');
    selSQL.Append('HAVING (Orders.CustomerID = ' + ViewState['CustomerID'].ToString() + ')');


    dgOrders.Editable:=False;
    dgOrders.AutoGenerateColumns:=False;
    dgOrders.PageSize:=15;
    dgOrders.AllowPaging := True;
    dgOrders.DataKeyField := 'OrderID';
    dgOrders.SelectSQL := selSQL.ToString;
    dgOrders.BindData;

    dgOrders.ErrorLabel := ErrorMessage;

    //submenu
    BindSubMenu;
  end
  else
    ErrorMessage.Text := 'Customer ID not found!';
end; (*Page_Load*)

procedure TucOrders.OnInit(e: System.EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);



end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TucOrders.InitializeComponent;
begin
  Include(Self.dgOrders.DeleteCommand, Self.dgOrders_DeleteCommand);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}



procedure TucOrders.GetCustomer(const cid: string);
var
  selSQL : string;
  dr : BDPDataReader;
begin
  selSQL := 'SELECT * FROM Customers WHERE CustomerID = ' + cid + ' And (IsAdmin <> 1 OR IsAdmin is null)';
  try
    dr := THelperDB.FillReader(selSQL);
    while dr.Read do
    begin
      lblCustomerID.Text := dr['CustomerID'].ToString();
      lblCustomerName.Text := dr['FullName'].ToString();
      lblCustomerEmail.Text := dr['EmailAddress'].ToString();
    end;
  except on E:Exception do
    ErrorMessage.Text := 'Could not locate customer. Error: '  + e.ToString();
  end;

end; (*GetCustomer*)

procedure TucOrders.dgOrders_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  dgOrders.DeleteSQL:= 'DELETE FROM Orders Where CustomerID = ' + ViewState['CustomerID'].ToString + ' AND OrderID = ';
end; (*dgOrders_DeleteCommand*)

procedure TucOrders.BindSubMenu;
var
  al : ArrayList;
begin
  al := ArrayList.Create;

  al.Add(TLinkList.Create('Customers', 'default.aspx?action=customers'));

  dlSubMenu.DataSource := al;
  dlSubMenu.DataBind();
end;

end.
